from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EXtremeScaleDomain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEXtremeScaleDomain");
  exportedObject.put("roleName", "WebSphereEXtremeScaleDomain");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomain.password", objid, "password","EXtremeScaleDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomain.name", objid, "name","EXtremeScaleDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomain.userid", objid, "userId","EXtremeScaleDomain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"EXtremeScaleDomain");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EXtremeScaleDomain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EXtremeScaleDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.extremescaledomain.password", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extremescaledomain.name", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.extremescaledomain.userid", None));
  print "Creating EXtremeScaleDomain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EXtremeScaleDomain", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomain');

def update(objid,jsonobject):
  Util.pushPathElement('EXtremeScaleDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomain.password", None), "password","EXtremeScaleDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomain.name", None), "name","EXtremeScaleDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomain.userid", None), "userId","EXtremeScaleDomain");
  if len(atts) != 0:
    print "Modifying EXtremeScaleDomain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EXtremeScaleDomain configuration up to date.";

  Property.removeProperties(objid, 'properties',"EXtremeScaleDomain");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomain');
