from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EXtremeScaleDomainEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEXtremeScaleDomainEndpoint");
  exportedObject.put("roleName", "WebSphereEXtremeScaleDomainEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomainendpoint.name", objid, "name","EXtremeScaleDomainEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extremescaledomainendpoint.hostname", objid, "hostName","EXtremeScaleDomainEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"EXtremeScaleDomainEndpoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EXtremeScaleDomainEndpoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EXtremeScaleDomainEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomainEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extremescaledomainendpoint.name", None));
  Util.addIfNotNone(properties, "hostName", roleProperties.optString("websphere.extremescaledomainendpoint.hostname", None));
  print "Creating EXtremeScaleDomainEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EXtremeScaleDomainEndpoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomainEndpoint');

def update(objid,jsonobject):
  Util.pushPathElement('EXtremeScaleDomainEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("EXtremeScaleDomainEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomainendpoint.name", None), "name","EXtremeScaleDomainEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extremescaledomainendpoint.hostname", None), "hostName","EXtremeScaleDomainEndpoint");
  if len(atts) != 0:
    print "Modifying EXtremeScaleDomainEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EXtremeScaleDomainEndpoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"EXtremeScaleDomainEndpoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EXtremeScaleDomainEndpoint');
