from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from CustomElasticityAction import CustomElasticityAction
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ElasticityAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereElasticityAction");
  exportedObject.put("roleName", "WebSphereElasticityAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.elasticityaction.actiontype", objid, "actionType","ElasticityAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.elasticityaction.stepnum", objid, "stepNum","ElasticityAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ElasticityAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ElasticityAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "actionType", roleProperties.optString("websphere.elasticityaction.actiontype", None));
  Util.addIfNotNone(properties, "stepNum", roleProperties.optString("websphere.elasticityaction.stepnum", None));
  print "Creating ElasticityAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ElasticityAction", parentid, properties);
  Util.popPathElement('ElasticityAction');

def update(objid,jsonobject):
  Util.pushPathElement('ElasticityAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.elasticityaction.actiontype", None), "actionType","ElasticityAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.elasticityaction.stepnum", None), "stepNum","ElasticityAction");
  if len(atts) != 0:
    print "Modifying ElasticityAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ElasticityAction configuration up to date.";
  Util.popPathElement('ElasticityAction');

def removeElasticityActions(objid, attributeName, parentType):
  actions = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if actions is not None and len(actions) > 0:
    for action in actions:
      if len(action) > 0:
        Util.remove(action);

def exportElasticityActions(objid, respath, extraObjects, typeFolders, attributeName, parentType):
  counterElasticityAction = 0;
  counterCustomElasticityAction = 0;

  actions = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if actions is not None and len(actions) > 0:
    for action in actions:
      if len(action) > 0:
        if action.find("#ElasticityAction_") != -1:
          returndict = Util.createTypeFolder(respath, "ElasticityAction", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, _export(action, currespath, 'ElasticityAction%s' % counterElasticityAction));
          counterElasticityAction = counterElasticityAction + 1;
        elif action.find("#CustomElasticityAction_") != -1:
          returndict = Util.createTypeFolder(respath, "CustomElasticityAction", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, CustomElasticityAction._export(action, currespath, 'CustomElasticityAction%s' % counterCustomElasticityAction));
          counterCustomElasticityAction = counterCustomElasticityAction + 1;

  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole):
  if currole == "WebSphereElasticityAction":
    create(objid, curjsonobject);
    return 1;
  elif currole == "WebSphereCustomElasticityAction":
    CustomElasticityAction.create(objid, curjsonobject);
    return 1;
  return 0;
