from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GroupExt')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGroupExt");
  exportedObject.put("roleName", "WebSphereGroupExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.groupext.name", objid, "name","GroupExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.groupext.accessid", objid, "accessId","GroupExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GroupExt');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GroupExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("GroupExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.groupext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.groupext.accessid", None));
  print "Creating GroupExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GroupExt", parentid, properties);
  Util.popPathElement('GroupExt');

def update(objid,jsonobject):
  Util.pushPathElement('GroupExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("GroupExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.groupext.name", None), "name","GroupExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.groupext.accessid", None), "accessId","GroupExt");
  if len(atts) != 0:
    print "Modifying GroupExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GroupExt configuration up to date.";

  Util.popPathElement('GroupExt');
