from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JavaVirtualMachine')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJavaVirtualMachine");
  exportedObject.put("roleName", "WebSphereJavaVirtualMachine");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.internalclassaccessmode", objid, "internalClassAccessMode","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.debugargs", objid, "debugArgs","JavaVirtualMachine");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.javavirtualmachine.classpath", objid, "classpath","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.initialheapsize", objid, "initialHeapSize","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.runhprof", objid, "runHProf","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.genericjvmarguments", objid, "genericJvmArguments","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.hprofarguments", objid, "hprofArguments","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.osname", objid, "osName","JavaVirtualMachine");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.javavirtualmachine.bootclasspath", objid, "bootClasspath","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.verbosemodejni", objid, "verboseModeJNI","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.maximumheapsize", objid, "maximumHeapSize","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.disablejit", objid, "disableJIT","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.verbosemodegarbagecollection", objid, "verboseModeGarbageCollection","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.executablejarfilename", objid, "executableJarFileName","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.verbosemodeclass", objid, "verboseModeClass","JavaVirtualMachine");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachine.debugmode", objid, "debugMode","JavaVirtualMachine");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid,respath,extraObjects,typeFolders,'systemProperties',"JavaVirtualMachine");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JavaVirtualMachine');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JavaVirtualMachine')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaVirtualMachine resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "internalClassAccessMode", roleProperties.optString("websphere.javavirtualmachine.internalclassaccessmode", None));
  Util.addIfNotNone(properties, "debugArgs", roleProperties.optString("websphere.javavirtualmachine.debugargs", None));
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.javavirtualmachine.classpath", None));
  Util.addIfNotNone(properties, "initialHeapSize", roleProperties.optString("websphere.javavirtualmachine.initialheapsize", None));
  Util.addIfNotNone(properties, "runHProf", roleProperties.optString("websphere.javavirtualmachine.runhprof", None));
  Util.addIfNotNone(properties, "genericJvmArguments", roleProperties.optString("websphere.javavirtualmachine.genericjvmarguments", None));
  Util.addIfNotNone(properties, "hprofArguments", roleProperties.optString("websphere.javavirtualmachine.hprofarguments", None));
  Util.addIfNotNone(properties, "osName", roleProperties.optString("websphere.javavirtualmachine.osname", None));
  Util.addPathProperty(properties, "bootClasspath", roleProperties.optString("websphere.javavirtualmachine.bootclasspath", None));
  Util.addIfNotNone(properties, "verboseModeJNI", roleProperties.optString("websphere.javavirtualmachine.verbosemodejni", None));
  Util.addIfNotNone(properties, "maximumHeapSize", roleProperties.optString("websphere.javavirtualmachine.maximumheapsize", None));
  Util.addIfNotNone(properties, "disableJIT", roleProperties.optString("websphere.javavirtualmachine.disablejit", None));
  Util.addIfNotNone(properties, "verboseModeGarbageCollection", roleProperties.optString("websphere.javavirtualmachine.verbosemodegarbagecollection", None));
  Util.addIfNotNone(properties, "executableJarFileName", roleProperties.optString("websphere.javavirtualmachine.executablejarfilename", None));
  Util.addIfNotNone(properties, "verboseModeClass", roleProperties.optString("websphere.javavirtualmachine.verbosemodeclass", None));
  Util.addIfNotNone(properties, "debugMode", roleProperties.optString("websphere.javavirtualmachine.debugmode", None));
  print "Creating JavaVirtualMachine with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JavaVirtualMachine", parentid, properties);

  Property.removeProperties(objid, 'systemProperties',"JavaVirtualMachine");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JavaVirtualMachine');

def update(objid,jsonobject):
  Util.pushPathElement('JavaVirtualMachine')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaVirtualMachine resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.internalclassaccessmode", None), "internalClassAccessMode","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.debugargs", None), "debugArgs","JavaVirtualMachine");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.classpath", None), "classpath","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.initialheapsize", None), "initialHeapSize","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.runhprof", None), "runHProf","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.genericjvmarguments", None), "genericJvmArguments","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.hprofarguments", None), "hprofArguments","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.osname", None), "osName","JavaVirtualMachine");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.bootclasspath", None), "bootClasspath","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.verbosemodejni", None), "verboseModeJNI","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.maximumheapsize", None), "maximumHeapSize","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.disablejit", None), "disableJIT","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.verbosemodegarbagecollection", None), "verboseModeGarbageCollection","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.executablejarfilename", None), "executableJarFileName","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.verbosemodeclass", None), "verboseModeClass","JavaVirtualMachine");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachine.debugmode", None), "debugMode","JavaVirtualMachine");
  if len(atts) != 0:
    print "Modifying JavaVirtualMachine with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JavaVirtualMachine configuration up to date.";

  Property.removeProperties(objid, 'systemProperties',"JavaVirtualMachine");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('JavaVirtualMachine');
