#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageDestinationRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageDestinationRef");
  exportedObject.put("roleName", "WebSphereMessageDestinationRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.name", objid, "name","MessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.type", objid, "type","MessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.mappedname", objid, "mappedName","MessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.lookupname", objid, "lookupName","MessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.link", objid, "link","MessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestinationref.usage", objid, "usage","MessageDestinationRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'MessageDestinationRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'MessageDestinationRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageDestinationRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MessageDestinationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageDestinationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.messagedestinationref.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.messagedestinationref.type", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.messagedestinationref.mappedname", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.messagedestinationref.lookupname", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.messagedestinationref.link", None));
  Util.addIfNotNone(properties, "usage", roleProperties.optString("websphere.messagedestinationref.usage", None));
  print "Creating MessageDestinationRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageDestinationRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('MessageDestinationRef');

def update(objid,jsonobject):
  Util.pushPathElement('MessageDestinationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageDestinationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.name", None), "name","MessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.type", None), "type","MessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.mappedname", None), "mappedName","MessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.lookupname", None), "lookupName","MessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.link", None), "link","MessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestinationref.usage", None), "usage","MessageDestinationRef");
  if len(atts) != 0:
    print "Modifying MessageDestinationRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageDestinationRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'MessageDestinationRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'MessageDestinationRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('MessageDestinationRef');
