from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from EndPoint import EndPoint
from OverlayEndpoint import OverlayEndpoint
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('NamedEndPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereNamedEndPoint");
  exportedObject.put("roleName", "WebSphereNamedEndPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namedendpoint.endpointname", objid, "endPointName","NamedEndPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  endpoint = Util.getOptionalAttribute(objid, 'endPoint',"NamedEndPoint");
  if len(endpoint) > 0:
    if endpoint.find("#EndPoint_") != -1:
      returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, EndPoint._export(endpoint, currespath, "EndPoint"));
    elif endpoint.find("#OverlayEndpoint_") != -1:
      returndict = Util.createTypeFolder(respath, "OverlayEndpoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, OverlayEndpoint._export(endpoint, currespath, "OverlayEndpoint"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('NamedEndPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('NamedEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("NamedEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "endPointName", roleProperties.optString("websphere.namedendpoint.endpointname", None));
  print "Creating NamedEndPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("NamedEndPoint", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereEndPoint":
        EndPoint.create(objid, curjsonobject, 'endPoint');
      elif currole == "WebSphereOverlayEndpoint":
        OverlayEndpoint.create(objid, curjsonobject, 'endPoint');
  Util.popPathElement('NamedEndPoint');

def update(objid,jsonobject):
  Util.pushPathElement('NamedEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("NamedEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namedendpoint.endpointname", None), "endPointName","NamedEndPoint");
  if len(atts) != 0:
    print "Modifying NamedEndPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "NamedEndPoint configuration up to date.";

  endpoint = Util.getOptionalAttribute(objid, 'endPoint',"NamedEndPoint");
  if len(endpoint) > 0:
    Util.remove(endpoint);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereEndPoint":
        EndPoint.create(objid, curjsonobject, 'endPoint');
      elif currole == "WebSphereOverlayEndpoint":
        OverlayEndpoint.create(objid, curjsonobject, 'endPoint');
  Util.popPathElement('NamedEndPoint');
