from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "OutputQueueLimit";

  containmentpath = "%(parentconpath)sOutputQueueLimit:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('OutputQueueLimit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereOutputQueueLimit");
  exportedObject.put("roleName", "WebSphereOutputQueueLimit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.outputqueuelimit.maxjobage", objid, "maxJobAge","OutputQueueLimit");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.outputqueuelimit.maxjob", objid, "maxJob","OutputQueueLimit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('OutputQueueLimit');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("OutputQueueLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create OutputQueueLimit on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('OutputQueueLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("OutputQueueLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxJobAge", roleProperties.optString("websphere.outputqueuelimit.maxjobage", None));
  Util.addIfNotNone(properties, "maxJob", roleProperties.optString("websphere.outputqueuelimit.maxjob", None));
  print "Creating OutputQueueLimit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("OutputQueueLimit", parentid, properties);
  Util.popPathElement('OutputQueueLimit');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('OutputQueueLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("OutputQueueLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.outputqueuelimit.maxjobage", None), "maxJobAge","OutputQueueLimit");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.outputqueuelimit.maxjob", None), "maxJob","OutputQueueLimit");
  if len(atts) != 0:
    print "Modifying OutputQueueLimit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "OutputQueueLimit configuration up to date.";

  Util.popPathElement('OutputQueueLimit');
