from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PluginProperties')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePluginProperties");
  exportedObject.put("roleName", "WebSpherePluginProperties");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.logfilename", objid, "LogFilename","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.configfilename", objid, "ConfigFilename","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.remotekeyringfilename", objid, "RemoteKeyRingFilename","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.loglevel", objid, "LogLevel","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.pluginpropagation", objid, "PluginPropagation","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.acceptallcontent", objid, "AcceptAllContent","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.plugininstallroot", objid, "PluginInstallRoot","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.ignorednsfailures", objid, "IgnoreDNSFailures","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.esiinvalidationmonitor", objid, "ESIInvalidationMonitor","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.iisdisablenagle", objid, "IISDisableNagle","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.remoteconfigfilename", objid, "RemoteConfigFilename","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.plugingeneration", objid, "PluginGeneration","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.responsechunksize", objid, "ResponseChunkSize","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.refreshinterval", objid, "RefreshInterval","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.vhostmatchingcompat", objid, "VHostMatchingCompat","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.asdisablenagle", objid, "ASDisableNagle","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.iispluginpriority", objid, "IISPluginPriority","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.keyringfilename", objid, "KeyRingFilename","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.chunkedresponse", objid, "ChunkedResponse","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.esienable", objid, "ESIEnable","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.esimaxcachesize", objid, "ESIMaxCacheSize","PluginProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginproperties.appserverportpreference", objid, "AppServerPortPreference","PluginProperties");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"PluginProperties");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PluginProperties');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PluginProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "LogFilename", roleProperties.optString("websphere.pluginproperties.logfilename", None));
  Util.addIfNotNone(properties, "ConfigFilename", roleProperties.optString("websphere.pluginproperties.configfilename", None));
  Util.addIfNotNone(properties, "RemoteKeyRingFilename", roleProperties.optString("websphere.pluginproperties.remotekeyringfilename", None));
  Util.addIfNotNone(properties, "LogLevel", roleProperties.optString("websphere.pluginproperties.loglevel", None));
  Util.addIfNotNone(properties, "PluginPropagation", roleProperties.optString("websphere.pluginproperties.pluginpropagation", None));
  Util.addIfNotNone(properties, "AcceptAllContent", roleProperties.optString("websphere.pluginproperties.acceptallcontent", None));
  Util.addIfNotNone(properties, "PluginInstallRoot", roleProperties.optString("websphere.pluginproperties.plugininstallroot", None));
  Util.addIfNotNone(properties, "IgnoreDNSFailures", roleProperties.optString("websphere.pluginproperties.ignorednsfailures", None));
  Util.addIfNotNone(properties, "ESIInvalidationMonitor", roleProperties.optString("websphere.pluginproperties.esiinvalidationmonitor", None));
  Util.addIfNotNone(properties, "IISDisableNagle", roleProperties.optString("websphere.pluginproperties.iisdisablenagle", None));
  Util.addIfNotNone(properties, "RemoteConfigFilename", roleProperties.optString("websphere.pluginproperties.remoteconfigfilename", None));
  Util.addIfNotNone(properties, "PluginGeneration", roleProperties.optString("websphere.pluginproperties.plugingeneration", None));
  Util.addIfNotNone(properties, "ResponseChunkSize", roleProperties.optString("websphere.pluginproperties.responsechunksize", None));
  Util.addIfNotNone(properties, "RefreshInterval", roleProperties.optString("websphere.pluginproperties.refreshinterval", None));
  Util.addIfNotNone(properties, "VHostMatchingCompat", roleProperties.optString("websphere.pluginproperties.vhostmatchingcompat", None));
  Util.addIfNotNone(properties, "ASDisableNagle", roleProperties.optString("websphere.pluginproperties.asdisablenagle", None));
  Util.addIfNotNone(properties, "IISPluginPriority", roleProperties.optString("websphere.pluginproperties.iispluginpriority", None));
  Util.addIfNotNone(properties, "KeyRingFilename", roleProperties.optString("websphere.pluginproperties.keyringfilename", None));
  Util.addIfNotNone(properties, "ChunkedResponse", roleProperties.optString("websphere.pluginproperties.chunkedresponse", None));
  Util.addIfNotNone(properties, "ESIEnable", roleProperties.optString("websphere.pluginproperties.esienable", None));
  Util.addIfNotNone(properties, "ESIMaxCacheSize", roleProperties.optString("websphere.pluginproperties.esimaxcachesize", None));
  Util.addIfNotNone(properties, "AppServerPortPreference", roleProperties.optString("websphere.pluginproperties.appserverportpreference", None));
  print "Creating PluginProperties with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PluginProperties", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PluginProperties');

def update(objid,jsonobject):
  Util.pushPathElement('PluginProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.logfilename", None), "LogFilename","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.configfilename", None), "ConfigFilename","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.remotekeyringfilename", None), "RemoteKeyRingFilename","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.loglevel", None), "LogLevel","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.pluginpropagation", None), "PluginPropagation","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.acceptallcontent", None), "AcceptAllContent","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.plugininstallroot", None), "PluginInstallRoot","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.ignorednsfailures", None), "IgnoreDNSFailures","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.esiinvalidationmonitor", None), "ESIInvalidationMonitor","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.iisdisablenagle", None), "IISDisableNagle","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.remoteconfigfilename", None), "RemoteConfigFilename","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.plugingeneration", None), "PluginGeneration","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.responsechunksize", None), "ResponseChunkSize","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.refreshinterval", None), "RefreshInterval","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.vhostmatchingcompat", None), "VHostMatchingCompat","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.asdisablenagle", None), "ASDisableNagle","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.iispluginpriority", None), "IISPluginPriority","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.keyringfilename", None), "KeyRingFilename","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.chunkedresponse", None), "ChunkedResponse","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.esienable", None), "ESIEnable","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.esimaxcachesize", None), "ESIMaxCacheSize","PluginProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginproperties.appserverportpreference", None), "AppServerPortPreference","PluginProperties");
  if len(atts) != 0:
    print "Modifying PluginProperties with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PluginProperties configuration up to date.";

  Property.removeProperties(objid, 'properties',"PluginProperties");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PluginProperties');
