from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAudit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAudit");
  exportedObject.put("roleName", "WebSphereSIBAudit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibaudit.allowaudit", objid, "allowAudit","SIBAudit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAudit');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "allowAudit", roleProperties.optString("websphere.sibaudit.allowaudit", None));
  print "Creating SIBAudit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAudit", parentid, properties);
  Util.popPathElement('SIBAudit');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibaudit.allowaudit", None), "allowAudit","SIBAudit");
  if len(atts) != 0:
    print "Modifying SIBAudit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAudit configuration up to date.";

  Util.popPathElement('SIBAudit');
