from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthAlias')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthAlias");
  exportedObject.put("roleName", "WebSphereSIBAuthAlias");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthalias.inheritdefaults", objid, "inheritDefaults","SIBAuthAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthalias.identifier", objid, "identifier","SIBAuthAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthalias.busname", objid, "busName","SIBAuthAlias");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthAlias');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthAlias')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthAlias resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthalias.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthalias.identifier", None));
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibauthalias.busname", None));
  print "Creating SIBAuthAlias with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthAlias", parentid, properties);
  Util.popPathElement('SIBAuthAlias');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthAlias')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthAlias resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthalias.inheritdefaults", None), "inheritDefaults","SIBAuthAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthalias.identifier", None), "identifier","SIBAuthAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthalias.busname", None), "busName","SIBAuthAlias");
  if len(atts) != 0:
    print "Modifying SIBAuthAlias with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthAlias configuration up to date.";

  Util.popPathElement('SIBAuthAlias');
