from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthPort')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthPort");
  exportedObject.put("roleName", "WebSphereSIBAuthPort");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthport.inheritdefaults", objid, "inheritDefaults","SIBAuthPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthport.identifier", objid, "identifier","SIBAuthPort");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthPort');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthport.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthport.identifier", None));
  print "Creating SIBAuthPort with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthPort", parentid, properties);
  Util.popPathElement('SIBAuthPort');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthport.inheritdefaults", None), "inheritDefaults","SIBAuthPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthport.identifier", None), "identifier","SIBAuthPort");
  if len(atts) != 0:
    print "Modifying SIBAuthPort with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthPort configuration up to date.";

  Util.popPathElement('SIBAuthPort');
