from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBusMemberTargetRef import SIBusMemberTargetRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBLinkRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBLinkRef");
  exportedObject.put("roleName", "WebSphereSIBLinkRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblinkref.name", objid, "name","SIBLinkRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblinkref.exceptiondiscardreliability", objid, "exceptionDiscardReliability","SIBLinkRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblinkref.exceptiondestination", objid, "exceptionDestination","SIBLinkRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siblinkref.preferlocalqueuepoints", objid, "preferLocalQueuePoints","SIBLinkRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  engine = Util.getOptionalAttribute(objid, 'engine',"SIBLinkRef");
  if engine is not None and len(engine) > 0:
    returndict = Util.createTypeFolder(respath, "SIBusMemberTargetRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBusMemberTargetRef._export(engine, currespath, "SIBus Member Target Ref"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBLinkRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBLinkRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLinkRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.siblinkref.name", None));
  Util.addIfNotNone(properties, "exceptionDiscardReliability", roleProperties.optString("websphere.siblinkref.exceptiondiscardreliability", None));
  Util.addIfNotNone(properties, "exceptionDestination", roleProperties.optString("websphere.siblinkref.exceptiondestination", None));
  Util.addIfNotNone(properties, "preferLocalQueuePoints", roleProperties.optString("websphere.siblinkref.preferlocalqueuepoints", None));
  print "Creating SIBLinkRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBLinkRef", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMemberTargetRef":
        SIBusMemberTargetRef.doImport(objid, curjsonobject);
  Util.popPathElement('SIBLinkRef');

def update(objid,jsonobject):
  Util.pushPathElement('SIBLinkRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBLinkRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblinkref.name", None), "name","SIBLinkRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblinkref.exceptiondiscardreliability", None), "exceptionDiscardReliability","SIBLinkRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblinkref.exceptiondestination", None), "exceptionDestination","SIBLinkRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siblinkref.preferlocalqueuepoints", None), "preferLocalQueuePoints","SIBLinkRef");
  if len(atts) != 0:
    print "Modifying SIBLinkRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBLinkRef configuration up to date.";

  engine = Util.getOptionalAttribute(objid, 'engine',"SIBLinkRef");
  if engine is not None and len(engine) > 0:
    Util.remove(engine);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBusMemberTargetRef":
        SIBusMemberTargetRef.doImport(objid, curjsonobject);

  Util.popPathElement('SIBLinkRef');
