from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBTopicSpace')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBTopicSpace");
  exportedObject.put("roleName", "WebSphereSIBTopicSpace");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.receiveallowed", objid, "receiveAllowed","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.persistredeliverycount", objid, "persistRedeliveryCount","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.defaultpriority", objid, "defaultPriority","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.identifier", objid, "identifier","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.instancetype", objid, "instanceType","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.maxreliability", objid, "maxReliability","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.exceptiondestination", objid, "exceptionDestination","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.overrideofqosbyproducerallowed", objid, "overrideOfQOSByProducerAllowed","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.topicaccesscheckrequired", objid, "topicAccessCheckRequired","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.blockedretrytimeout", objid, "blockedRetryTimeout","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.reliability", objid, "reliability","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.description", objid, "description","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.uuid", objid, "uuid","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.exceptiondiscardreliability", objid, "exceptionDiscardReliability","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.maintainstrictmessageorder", objid, "maintainStrictMessageOrder","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.sendallowed", objid, "sendAllowed","SIBTopicSpace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspace.maxfaileddeliveries", objid, "maxFailedDeliveries","SIBTopicSpace");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBTopicSpace');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBTopicSpace')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "receiveAllowed", roleProperties.optString("websphere.sibtopicspace.receiveallowed", None));
  Util.addIfNotNone(properties, "persistRedeliveryCount", roleProperties.optString("websphere.sibtopicspace.persistredeliverycount", None));
  Util.addIfNotNone(properties, "defaultPriority", roleProperties.optString("websphere.sibtopicspace.defaultpriority", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibtopicspace.identifier", None));
  Util.addIfNotNone(properties, "instanceType", roleProperties.optString("websphere.sibtopicspace.instancetype", None));
  Util.addIfNotNone(properties, "maxReliability", roleProperties.optString("websphere.sibtopicspace.maxreliability", None));
  Util.addIfNotNone(properties, "exceptionDestination", roleProperties.optString("websphere.sibtopicspace.exceptiondestination", None));
  Util.addIfNotNone(properties, "overrideOfQOSByProducerAllowed", roleProperties.optString("websphere.sibtopicspace.overrideofqosbyproducerallowed", None));
  Util.addIfNotNone(properties, "topicAccessCheckRequired", roleProperties.optString("websphere.sibtopicspace.topicaccesscheckrequired", None));
  Util.addIfNotNone(properties, "blockedRetryTimeout", roleProperties.optString("websphere.sibtopicspace.blockedretrytimeout", None));
  Util.addIfNotNone(properties, "reliability", roleProperties.optString("websphere.sibtopicspace.reliability", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibtopicspace.description", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibtopicspace.uuid", None));
  Util.addIfNotNone(properties, "exceptionDiscardReliability", roleProperties.optString("websphere.sibtopicspace.exceptiondiscardreliability", None));
  Util.addIfNotNone(properties, "maintainStrictMessageOrder", roleProperties.optString("websphere.sibtopicspace.maintainstrictmessageorder", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibtopicspace.sendallowed", None));
  Util.addIfNotNone(properties, "maxFailedDeliveries", roleProperties.optString("websphere.sibtopicspace.maxfaileddeliveries", None));
  print "Creating SIBTopicSpace with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBTopicSpace", parentid, properties);
  Util.popPathElement('SIBTopicSpace');

def update(objid,jsonobject):
  Util.pushPathElement('SIBTopicSpace')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.receiveallowed", None), "receiveAllowed","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.persistredeliverycount", None), "persistRedeliveryCount","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.defaultpriority", None), "defaultPriority","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.identifier", None), "identifier","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.instancetype", None), "instanceType","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.maxreliability", None), "maxReliability","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.exceptiondestination", None), "exceptionDestination","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.overrideofqosbyproducerallowed", None), "overrideOfQOSByProducerAllowed","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.topicaccesscheckrequired", None), "topicAccessCheckRequired","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.blockedretrytimeout", None), "blockedRetryTimeout","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.reliability", None), "reliability","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.description", None), "description","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.uuid", None), "uuid","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.exceptiondiscardreliability", None), "exceptionDiscardReliability","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.maintainstrictmessageorder", None), "maintainStrictMessageOrder","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.sendallowed", None), "sendAllowed","SIBTopicSpace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspace.maxfaileddeliveries", None), "maxFailedDeliveries","SIBTopicSpace");
  if len(atts) != 0:
    print "Modifying SIBTopicSpace with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBTopicSpace configuration up to date.";

  Util.popPathElement('SIBTopicSpace');
