from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SSLOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'SSLOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSSLOutboundChannel");
  exportedObject.put("roleName", "WebSphereSSLOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ssloutboundchannel.name", objid, "name","SSLOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ssloutboundchannel.sslconfigalias", objid, "sslConfigAlias","SSLOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SSLOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SSLOutboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SSLOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ssloutboundchannel.name", None));
  Util.addIfNotNone(properties, "sslConfigAlias", roleProperties.optString("websphere.ssloutboundchannel.sslconfigalias", None));
  print "Creating SSLOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SSLOutboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SSLOutboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SSLOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ssloutboundchannel.name", None), "name","SSLOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ssloutboundchannel.sslconfigalias", None), "sslConfigAlias","SSLOutboundChannel");
  if len(atts) != 0:
    print "Modifying SSLOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SSLOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"SSLOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SSLOutboundChannel');
