from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.typedproperty.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'TypedProperty');

  containmentpath = "%(parentconpath)sTypedProperty:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('TypedProperty')

  name = Util.getRequiredAttribute(objid, "name", 'TypedProperty');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTypedProperty");
  exportedObject.put("roleName", "WebSphereTypedProperty");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.validationexpression", objid, "validationExpression","TypedProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.name", objid, "name","TypedProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.type", objid, "type","TypedProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.description", objid, "description","TypedProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.value", objid, "value","TypedProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.typedproperty.required", objid, "required","TypedProperty");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TypedProperty');
  return result;


'''
  The Property objects should only be created by Property.createObjIfRole(...) in parent object.
  Remove doImport(..) so importobject.py will not create the Propety object the second time via containmentpath.
'''
def _doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TypedProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.typedproperty.name"):
    raise Exception("Resource role properties does not contain websphere.typedproperty.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create TypedProperty on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('TypedProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("TypedProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.typedproperty.name"):
    raise Exception("Resource role properties does not contain websphere.typedproperty.name!");

  properties = [];
  Util.addIfNotNone(properties, "validationExpression", roleProperties.optString("websphere.typedproperty.validationexpression", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.typedproperty.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.typedproperty.type", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.typedproperty.description", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.typedproperty.value", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.typedproperty.required", None));
  print "Creating TypedProperty with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TypedProperty", parentid, properties, attName);
  Util.popPathElement('TypedProperty');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('TypedProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("TypedProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.typedproperty.name"):
    raise Exception("Resource role properties does not contain websphere.typedproperty.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.validationexpression", None), "validationExpression","TypedProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.name", None), "name","TypedProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.type", None), "type","TypedProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.description", None), "description","TypedProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.value", None), "value","TypedProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.typedproperty.required", None), "required","TypedProperty");
  if len(atts) != 0:
    print "Modifying TypedProperty with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TypedProperty configuration up to date.";

  Util.popPathElement('TypedProperty');
