from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CentralizedInstallManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCentralizedInstallManager");
  exportedObject.put("roleName", "WebSphereCentralizedInstallManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.centralizedinstallmanager.defaultpassword", objid, "defaultPassword","CentralizedInstallManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.centralizedinstallmanager.defaultinstalllocation", objid, "defaultInstallLocation","CentralizedInstallManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.centralizedinstallmanager.defaultworkinglocation", objid, "defaultWorkingLocation","CentralizedInstallManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.centralizedinstallmanager.defaultusername", objid, "defaultUsername","CentralizedInstallManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CentralizedInstallManager');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CentralizedInstallManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("CentralizedInstallManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "defaultPassword", roleProperties.optString("websphere.centralizedinstallmanager.defaultpassword", None));
  Util.addIfNotNone(properties, "defaultInstallLocation", roleProperties.optString("websphere.centralizedinstallmanager.defaultinstalllocation", None));
  Util.addIfNotNone(properties, "defaultWorkingLocation", roleProperties.optString("websphere.centralizedinstallmanager.defaultworkinglocation", None));
  Util.addIfNotNone(properties, "defaultUsername", roleProperties.optString("websphere.centralizedinstallmanager.defaultusername", None));
  print "Creating CentralizedInstallManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CentralizedInstallManager", parentid, properties);
  Util.popPathElement('CentralizedInstallManager');

def update(objid,jsonobject):
  Util.pushPathElement('CentralizedInstallManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("CentralizedInstallManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.centralizedinstallmanager.defaultpassword", None), "defaultPassword","CentralizedInstallManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.centralizedinstallmanager.defaultinstalllocation", None), "defaultInstallLocation","CentralizedInstallManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.centralizedinstallmanager.defaultworkinglocation", None), "defaultWorkingLocation","CentralizedInstallManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.centralizedinstallmanager.defaultusername", None), "defaultUsername","CentralizedInstallManager");
  if len(atts) != 0:
    print "Modifying CentralizedInstallManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CentralizedInstallManager configuration up to date.";

  Util.popPathElement('CentralizedInstallManager');
