#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBLocalRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBLocalRef");
  exportedObject.put("roleName", "WebSphereEJBLocalRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.name", objid, "name","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.lookupname", objid, "lookupName","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.indeterminateejbref", objid, "indeterminateEJBRef","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.remote", objid, "remote","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.type", objid, "type","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.home", objid, "home","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.link", objid, "link","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.local", objid, "local","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.description", objid, "description","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.localhome", objid, "localHome","EJBLocalRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejblocalref.mappedname", objid, "mappedName","EJBLocalRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'EJBLocalRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  
  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'EJBLocalRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBLocalRef');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('EJBLocalRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBLocalRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ejblocalref.name", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.ejblocalref.lookupname", None));
  Util.addIfNotNone(properties, "indeterminateEJBRef", roleProperties.optString("websphere.ejblocalref.indeterminateejbref", None));
  Util.addIfNotNone(properties, "remote", roleProperties.optString("websphere.ejblocalref.remote", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.ejblocalref.type", None));
  Util.addIfNotNone(properties, "home", roleProperties.optString("websphere.ejblocalref.home", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.ejblocalref.link", None));
  Util.addIfNotNone(properties, "local", roleProperties.optString("websphere.ejblocalref.local", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.ejblocalref.description", None));
  Util.addIfNotNone(properties, "localHome", roleProperties.optString("websphere.ejblocalref.localhome", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.ejblocalref.mappedname", None));
  print "Creating EJBLocalRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBLocalRef", parentid, properties, attName);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('EJBLocalRef');

def update(objid,jsonobject):
  Util.pushPathElement('EJBLocalRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBLocalRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.name", None), "name","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.lookupname", None), "lookupName","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.indeterminateejbref", None), "indeterminateEJBRef","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.remote", None), "remote","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.type", None), "type","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.home", None), "home","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.link", None), "link","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.local", None), "local","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.description", None), "description","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.localhome", None), "localHome","EJBLocalRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejblocalref.mappedname", None), "mappedName","EJBLocalRef");
  if len(atts) != 0:
    print "Modifying EJBLocalRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBLocalRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'EJBLocalRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'EJBLocalRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);

  Util.popPathElement('EJBLocalRef');
