from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBTimer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBTimer");
  exportedObject.put("roleName", "WebSphereEJBTimer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.schedulerjndiname", objid, "schedulerJNDIName","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.tableprefix", objid, "tablePrefix","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.pollinterval", objid, "pollInterval","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.datasourcejndiname", objid, "datasourceJNDIName","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.numnptimerthreads", objid, "numNPTimerThreads","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.nonpersistenttimerretryinterval", objid, "nonPersistentTimerRetryInterval","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.numalarmthreads", objid, "numAlarmThreads","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.datasourcealias", objid, "datasourceAlias","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.nonpersistenttimerretrycount", objid, "nonPersistentTimerRetryCount","EJBTimer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbtimer.uniquetimermanagerfornp", objid, "uniqueTimerManagerForNP","EJBTimer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBTimer');
  return result;



def create(parentid, jsonobject, attName):
  Util.pushPathElement('EJBTimer')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBTimer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "schedulerJNDIName", roleProperties.optString("websphere.ejbtimer.schedulerjndiname", None));
  Util.addIfNotNone(properties, "tablePrefix", roleProperties.optString("websphere.ejbtimer.tableprefix", None));
  Util.addIfNotNone(properties, "pollInterval", roleProperties.optString("websphere.ejbtimer.pollinterval", None));
  Util.addIfNotNone(properties, "datasourceJNDIName", roleProperties.optString("websphere.ejbtimer.datasourcejndiname", None));
  Util.addIfNotNone(properties, "numNPTimerThreads", roleProperties.optString("websphere.ejbtimer.numnptimerthreads", None));
  Util.addIfNotNone(properties, "nonPersistentTimerRetryInterval", roleProperties.optString("websphere.ejbtimer.nonpersistenttimerretryinterval", None));
  Util.addIfNotNone(properties, "numAlarmThreads", roleProperties.optString("websphere.ejbtimer.numalarmthreads", None));
  Util.addIfNotNone(properties, "datasourceAlias", roleProperties.optString("websphere.ejbtimer.datasourcealias", None));
  Util.addIfNotNone(properties, "nonPersistentTimerRetryCount", roleProperties.optString("websphere.ejbtimer.nonpersistenttimerretrycount", None));
  Util.addIfNotNone(properties, "uniqueTimerManagerForNP", roleProperties.optString("websphere.ejbtimer.uniquetimermanagerfornp", None));
  print "Creating EJBTimer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBTimer", parentid, properties, attName);
  Util.popPathElement('EJBTimer');

def update(objid,jsonobject):
  Util.pushPathElement('EJBTimer')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBTimer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.schedulerjndiname", None), "schedulerJNDIName","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.tableprefix", None), "tablePrefix","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.pollinterval", None), "pollInterval","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.datasourcejndiname", None), "datasourceJNDIName","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.numnptimerthreads", None), "numNPTimerThreads","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.nonpersistenttimerretryinterval", None), "nonPersistentTimerRetryInterval","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.numalarmthreads", None), "numAlarmThreads","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.datasourcealias", None), "datasourceAlias","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.nonpersistenttimerretrycount", None), "nonPersistentTimerRetryCount","EJBTimer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbtimer.uniquetimermanagerfornp", None), "uniqueTimerManagerForNP","EJBTimer");
  if len(atts) != 0:
    print "Modifying EJBTimer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBTimer configuration up to date.";

  Util.popPathElement('EJBTimer');
