from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from EventGroupProfile import EventGroupProfile
from utilities import Util

__name_att__ = "websphere.eventgroupprofilelist.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EventGroupProfileList');

  containmentpath = "%(parentconpath)sEventGroupProfileList:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EventGroupProfileList')

  name = Util.getRequiredAttribute(objid, "name", 'EventGroupProfileList');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEventGroupProfileList");
  exportedObject.put("roleName", "WebSphereEventGroupProfileList");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventgroupprofilelist.name", objid, "name","EventGroupProfileList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventgroupprofilelist.category", objid, "category","EventGroupProfileList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventgroupprofilelist.providertype", objid, "providerType","EventGroupProfileList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventgroupprofilelist.jndiname", objid, "jndiName","EventGroupProfileList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventgroupprofilelist.description", objid, "description","EventGroupProfileList");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  eventgroupprofiles = Util.parseConfigIdListAttribute(objid, 'eventGroupProfiles',"EventGroupProfileList");
  for eventgroupprofile in eventgroupprofiles:
    if len(eventgroupprofile) > 0:
      returndict = Util.createTypeFolder(respath, "EventGroupProfile", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, EventGroupProfile._export(eventgroupprofile, currespath, 
                                                          Util.getRequiredAttribute(eventgroupprofile, "eventGroupName", 'EventGroupProfileList')));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EventGroupProfileList');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("EventGroupProfileList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.eventgroupprofilelist.name"):
    raise Exception("Resource role properties does not contain websphere.eventgroupprofilelist.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create EventGroupProfileList on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('EventGroupProfileList')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventGroupProfileList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventgroupprofilelist.name"):
    raise Exception("Resource role properties does not contain websphere.eventgroupprofilelist.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.eventgroupprofilelist.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.eventgroupprofilelist.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.eventgroupprofilelist.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.eventgroupprofilelist.jndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.eventgroupprofilelist.description", None));
  print "Creating EventGroupProfileList with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EventGroupProfileList", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereEventGroupProfile":
        EventGroupProfile.create(objid, curjsonobject);
  Util.popPathElement('EventGroupProfileList');
  return objid;
        
def update(objid,jsonobject):
  Util.pushPathElement('EventGroupProfileList')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventGroupProfileList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventgroupprofilelist.name"):
    raise Exception("Resource role properties does not contain websphere.eventgroupprofilelist.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventgroupprofilelist.name", None), "name","EventGroupProfileList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventgroupprofilelist.category", None), "category","EventGroupProfileList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventgroupprofilelist.providertype", None), "providerType","EventGroupProfileList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventgroupprofilelist.jndiname", None), "jndiName","EventGroupProfileList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventgroupprofilelist.description", None), "description","EventGroupProfileList");
  if len(atts) != 0:
    print "Modifying EventGroupProfileList with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EventGroupProfileList configuration up to date.";

  eventgroupprofiles = Util.parseConfigIdListAttribute(objid, 'eventGroupProfiles',"EventGroupProfileList");
  for eventgroupprofile in eventgroupprofiles:
    if len(eventgroupprofile) > 0:
      Util.remove(eventgroupprofile);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereEventGroupProfile":
        EventGroupProfile.create(objid, curjsonobject);
  Util.popPathElement('EventGroupProfileList');
