from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.filterfactoryprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'FilterFactoryProfile');

  containmentpath = "%(parentconpath)sFilterFactoryProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('FilterFactoryProfile')

  name = Util.getRequiredAttribute(objid, "name", 'FilterFactoryProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFilterFactoryProfile");
  exportedObject.put("roleName", "WebSphereFilterFactoryProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.name", objid, "name","FilterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.category", objid, "category","FilterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.providertype", objid, "providerType","FilterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.jndiname", objid, "jndiName","FilterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.filterconfigurationstring", objid, "filterConfigurationString","FilterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filterfactoryprofile.description", objid, "description","FilterFactoryProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('FilterFactoryProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("FilterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.filterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.filterfactoryprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create FilterFactoryProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('FilterFactoryProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("FilterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.filterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.filterfactoryprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.filterfactoryprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.filterfactoryprofile.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.filterfactoryprofile.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.filterfactoryprofile.jndiname", None));
  Util.addIfNotNone(properties, "filterConfigurationString", roleProperties.optString("websphere.filterfactoryprofile.filterconfigurationstring", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.filterfactoryprofile.description", None));
  print "Creating FilterFactoryProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("FilterFactoryProfile", parentid, properties);
  Util.popPathElement('FilterFactoryProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('FilterFactoryProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("FilterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.filterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.filterfactoryprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.name", None), "name","FilterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.category", None), "category","FilterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.providertype", None), "providerType","FilterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.jndiname", None), "jndiName","FilterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.filterconfigurationstring", None), "filterConfigurationString","FilterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filterfactoryprofile.description", None), "description","FilterFactoryProfile");
  if len(atts) != 0:
    print "Modifying FilterFactoryProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "FilterFactoryProfile configuration up to date.";

  Util.popPathElement('FilterFactoryProfile');
