from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GridMatchRule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGridMatchRule");
  exportedObject.put("roleName", "WebSphereGridMatchRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridmatchrule.matchexpression", objid, "matchExpression","GridMatchRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridmatchrule.priority", objid, "priority","GridMatchRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridmatchrule.matchaction", objid, "matchAction","GridMatchRule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GridMatchRule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GridMatchRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridMatchRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "matchExpression", roleProperties.optString("websphere.gridmatchrule.matchexpression", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.gridmatchrule.priority", None));
  Util.addIfNotNone(properties, "matchAction", roleProperties.optString("websphere.gridmatchrule.matchaction", None));
  print "Creating GridMatchRule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GridMatchRule", parentid, properties);
  Util.popPathElement('GridMatchRule');

def update(objid,jsonobject):
  Util.pushPathElement('GridMatchRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridMatchRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridmatchrule.matchexpression", None), "matchExpression","GridMatchRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridmatchrule.priority", None), "priority","GridMatchRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridmatchrule.matchaction", None), "matchAction","GridMatchRule");
  if len(atts) != 0:
    print "Modifying GridMatchRule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GridMatchRule configuration up to date.";

  Util.popPathElement('GridMatchRule');
