from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'HTTPOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHTTPOutboundChannel");
  exportedObject.put("roleName", "WebSphereHTTPOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpoutboundchannel.readtimeout", objid, "readTimeout","HTTPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpoutboundchannel.name", objid, "name","HTTPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpoutboundchannel.writetimeout", objid, "writeTimeout","HTTPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpoutboundchannel.keepalive", objid, "keepAlive","HTTPOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HTTPOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPOutboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HTTPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "readTimeout", roleProperties.optString("websphere.httpoutboundchannel.readtimeout", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.httpoutboundchannel.name", None));
  Util.addIfNotNone(properties, "writeTimeout", roleProperties.optString("websphere.httpoutboundchannel.writetimeout", None));
  Util.addIfNotNone(properties, "keepAlive", roleProperties.optString("websphere.httpoutboundchannel.keepalive", None));
  print "Creating HTTPOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HTTPOutboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPOutboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('HTTPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpoutboundchannel.readtimeout", None), "readTimeout","HTTPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpoutboundchannel.name", None), "name","HTTPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpoutboundchannel.writetimeout", None), "writeTimeout","HTTPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpoutboundchannel.keepalive", None), "keepAlive","HTTPOutboundChannel");
  if len(atts) != 0:
    print "Modifying HTTPOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HTTPOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"HTTPOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPOutboundChannel');
