from org.codehaus.jettison.json import JSONObject, JSONArray
from utilities import Util

__name_att__ = "websphere.jobclass.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'JobClass');

  containmentpath = "%(parentconpath)sJobClass:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('JobClass')

  name = Util.getRequiredAttribute(objid, "name", 'JobClass');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJobClass");
  exportedObject.put("roleName", "WebSphereJobClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobclass.name", objid, "name","JobClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobclass.description", objid, "description","JobClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JobClass');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("JobClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.jobclass.name"):
    raise Exception("Resource role properties does not contain websphere.jobclass.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create JobClass on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('JobClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.jobclass.name"):
    raise Exception("Resource role properties does not contain websphere.jobclass.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jobclass.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jobclass.description", None));
  print "Creating JobClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JobClass", parentid, properties);
  Util.popPathElement('JobClass');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JobClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.jobclass.name"):
    raise Exception("Resource role properties does not contain websphere.jobclass.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobclass.name", None), "name","JobClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobclass.description", None), "description","JobClass");
  if len(atts) != 0:
    print "Modifying JobClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JobClass configuration up to date.";

  Util.popPathElement('JobClass');
