from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseArchive')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseArchive");
  exportedObject.put("roleName", "WebSphereLooseArchive");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.archiveversion", objid, "archiveVersion","LooseArchive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.archivetype", objid, "archiveType","LooseArchive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.uri", objid, "uri","LooseArchive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.binariespath", objid, "binariesPath","LooseArchive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.resourcespath", objid, "resourcesPath","LooseArchive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchive.otherarchivetype", objid, "otherArchiveType","LooseArchive");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LooseArchive");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseArchive');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseArchive')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseArchive resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "archiveVersion", roleProperties.optString("websphere.loosearchive.archiveversion", None));
  Util.addIfNotNone(properties, "archiveType", roleProperties.optString("websphere.loosearchive.archivetype", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.loosearchive.uri", None));
  Util.addIfNotNone(properties, "binariesPath", roleProperties.optString("websphere.loosearchive.binariespath", None));
  Util.addIfNotNone(properties, "resourcesPath", roleProperties.optString("websphere.loosearchive.resourcespath", None));
  Util.addIfNotNone(properties, "otherArchiveType", roleProperties.optString("websphere.loosearchive.otherarchivetype", None));
  print "Creating LooseArchive with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseArchive", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseArchive');

def update(objid,jsonobject):
  Util.pushPathElement('LooseArchive')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseArchive resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.archiveversion", None), "archiveVersion","LooseArchive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.archivetype", None), "archiveType","LooseArchive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.uri", None), "uri","LooseArchive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.binariespath", None), "binariesPath","LooseArchive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.resourcespath", None), "resourcesPath","LooseArchive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchive.otherarchivetype", None), "otherArchiveType","LooseArchive");
  if len(atts) != 0:
    print "Modifying LooseArchive with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseArchive configuration up to date.";

  Property.removeProperties(objid, 'properties',"LooseArchive");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseArchive');
