from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseLibrary')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseLibrary");
  exportedObject.put("roleName", "WebSphereLooseLibrary");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.archiveversion", objid, "archiveVersion","LooseLibrary");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.archivetype", objid, "archiveType","LooseLibrary");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.uri", objid, "uri","LooseLibrary");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.binariespath", objid, "binariesPath","LooseLibrary");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.resourcespath", objid, "resourcesPath","LooseLibrary");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looselibrary.otherarchivetype", objid, "otherArchiveType","LooseLibrary");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LooseLibrary");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseLibrary');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseLibrary')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseLibrary resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "archiveVersion", roleProperties.optString("websphere.looselibrary.archiveversion", None));
  Util.addIfNotNone(properties, "archiveType", roleProperties.optString("websphere.looselibrary.archivetype", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.looselibrary.uri", None));
  Util.addIfNotNone(properties, "binariesPath", roleProperties.optString("websphere.looselibrary.binariespath", None));
  Util.addIfNotNone(properties, "resourcesPath", roleProperties.optString("websphere.looselibrary.resourcespath", None));
  Util.addIfNotNone(properties, "otherArchiveType", roleProperties.optString("websphere.looselibrary.otherarchivetype", None));
  print "Creating LooseLibrary with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseLibrary", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseLibrary');

def update(objid,jsonobject):
  Util.pushPathElement('LooseLibrary')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseLibrary resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.archiveversion", None), "archiveVersion","LooseLibrary");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.archivetype", None), "archiveType","LooseLibrary");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.uri", None), "uri","LooseLibrary");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.binariespath", None), "binariesPath","LooseLibrary");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.resourcespath", None), "resourcesPath","LooseLibrary");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looselibrary.otherarchivetype", None), "otherArchiveType","LooseLibrary");
  if len(atts) != 0:
    print "Modifying LooseLibrary with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseLibrary configuration up to date.";

  Property.removeProperties(objid, 'properties',"LooseLibrary");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseLibrary');
