from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.mqtopic.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MQTopic');

  containmentpath = "%(parentconpath)sMQTopic:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MQTopic')

  name = Util.getRequiredAttribute(objid, "name", 'MQTopic');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQTopic");
  exportedObject.put("roleName", "WebSphereMQTopic");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.integerencoding", objid, "integerEncoding","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.ccsid", objid, "CCSID","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.receiveconvert", objid, "receiveConvert","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.specifiedpriority", objid, "specifiedPriority","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.basetopicname", objid, "baseTopicName","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.wmqtopicname", objid, "wmqTopicName","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.category", objid, "category","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.specifiedexpiry", objid, "specifiedExpiry","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.sendasync", objid, "sendAsync","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.name", objid, "name","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.description", objid, "description","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.brokerpubqmgr", objid, "brokerPubQmgr","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.replytostyle", objid, "replyToStyle","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.mqmdwriteenabled", objid, "mqmdWriteEnabled","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.wildcardformat", objid, "wildcardFormat","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.priority", objid, "priority","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.mqmdreadenabled", objid, "mqmdReadEnabled","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.brokerpubqueue", objid, "brokerPubQueue","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.usenativeencoding", objid, "useNativeEncoding","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.brokerversion", objid, "brokerVersion","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.jndiname", objid, "jndiName","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.expiry", objid, "expiry","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.brokerccdursubqueue", objid, "brokerCCDurSubQueue","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.multicast", objid, "multicast","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.messagebody", objid, "messageBody","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.persistence", objid, "persistence","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.mqmdmessagecontext", objid, "mqmdMessageContext","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.providertype", objid, "providerType","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.floatingpointencoding", objid, "floatingPointEncoding","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.receiveccsid", objid, "receiveCCSID","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.brokerdursubqueue", objid, "brokerDurSubQueue","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.readahead", objid, "readAhead","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.decimalencoding", objid, "decimalEncoding","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.targetclient", objid, "targetClient","MQTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqtopic.readaheadclose", objid, "readAheadClose","MQTopic");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQTopic');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mqtopic.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopic.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MQTopic on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MQTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqtopic.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopic.name!");

  properties = [];
  Util.addIfNotNone(properties, "integerEncoding", roleProperties.optString("websphere.mqtopic.integerencoding", None));
  Util.addIfNotNone(properties, "CCSID", roleProperties.optString("websphere.mqtopic.ccsid", None));
  Util.addIfNotNone(properties, "receiveConvert", roleProperties.optString("websphere.mqtopic.receiveconvert", None));
  Util.addIfNotNone(properties, "specifiedPriority", roleProperties.optString("websphere.mqtopic.specifiedpriority", None));
  Util.addIfNotNone(properties, "baseTopicName", roleProperties.optString("websphere.mqtopic.basetopicname", None));
  Util.addIfNotNone(properties, "wmqTopicName", roleProperties.optString("websphere.mqtopic.wmqtopicname", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.mqtopic.category", None));
  Util.addIfNotNone(properties, "specifiedExpiry", roleProperties.optString("websphere.mqtopic.specifiedexpiry", None));
  Util.addIfNotNone(properties, "sendAsync", roleProperties.optString("websphere.mqtopic.sendasync", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqtopic.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mqtopic.description", None));
  Util.addIfNotNone(properties, "brokerPubQmgr", roleProperties.optString("websphere.mqtopic.brokerpubqmgr", None));
  Util.addIfNotNone(properties, "replyToStyle", roleProperties.optString("websphere.mqtopic.replytostyle", None));
  Util.addIfNotNone(properties, "mqmdWriteEnabled", roleProperties.optString("websphere.mqtopic.mqmdwriteenabled", None));
  Util.addIfNotNone(properties, "wildcardFormat", roleProperties.optString("websphere.mqtopic.wildcardformat", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.mqtopic.priority", None));
  Util.addIfNotNone(properties, "mqmdReadEnabled", roleProperties.optString("websphere.mqtopic.mqmdreadenabled", None));
  Util.addIfNotNone(properties, "brokerPubQueue", roleProperties.optString("websphere.mqtopic.brokerpubqueue", None));
  Util.addIfNotNone(properties, "useNativeEncoding", roleProperties.optString("websphere.mqtopic.usenativeencoding", None));
  Util.addIfNotNone(properties, "brokerVersion", roleProperties.optString("websphere.mqtopic.brokerversion", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.mqtopic.jndiname", None));
  Util.addIfNotNone(properties, "expiry", roleProperties.optString("websphere.mqtopic.expiry", None));
  Util.addIfNotNone(properties, "brokerCCDurSubQueue", roleProperties.optString("websphere.mqtopic.brokerccdursubqueue", None));
  Util.addIfNotNone(properties, "multicast", roleProperties.optString("websphere.mqtopic.multicast", None));
  Util.addIfNotNone(properties, "messageBody", roleProperties.optString("websphere.mqtopic.messagebody", None));
  Util.addIfNotNone(properties, "persistence", roleProperties.optString("websphere.mqtopic.persistence", None));
  Util.addIfNotNone(properties, "mqmdMessageContext", roleProperties.optString("websphere.mqtopic.mqmdmessagecontext", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mqtopic.providertype", None));
  Util.addIfNotNone(properties, "floatingPointEncoding", roleProperties.optString("websphere.mqtopic.floatingpointencoding", None));
  Util.addIfNotNone(properties, "receiveCCSID", roleProperties.optString("websphere.mqtopic.receiveccsid", None));
  Util.addIfNotNone(properties, "brokerDurSubQueue", roleProperties.optString("websphere.mqtopic.brokerdursubqueue", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.mqtopic.readahead", None));
  Util.addIfNotNone(properties, "decimalEncoding", roleProperties.optString("websphere.mqtopic.decimalencoding", None));
  Util.addIfNotNone(properties, "targetClient", roleProperties.optString("websphere.mqtopic.targetclient", None));
  Util.addIfNotNone(properties, "readAheadClose", roleProperties.optString("websphere.mqtopic.readaheadclose", None));
  print "Creating MQTopic with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQTopic", parentid, properties);
  Util.popPathElement('MQTopic');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqtopic.name"):
    raise Exception("Resource role properties does not contain websphere.mqtopic.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.integerencoding", None), "integerEncoding","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.ccsid", None), "CCSID","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.receiveconvert", None), "receiveConvert","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.specifiedpriority", None), "specifiedPriority","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.basetopicname", None), "baseTopicName","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.wmqtopicname", None), "wmqTopicName","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.category", None), "category","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.specifiedexpiry", None), "specifiedExpiry","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.sendasync", None), "sendAsync","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.name", None), "name","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.description", None), "description","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.brokerpubqmgr", None), "brokerPubQmgr","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.replytostyle", None), "replyToStyle","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.mqmdwriteenabled", None), "mqmdWriteEnabled","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.wildcardformat", None), "wildcardFormat","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.priority", None), "priority","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.mqmdreadenabled", None), "mqmdReadEnabled","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.brokerpubqueue", None), "brokerPubQueue","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.usenativeencoding", None), "useNativeEncoding","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.brokerversion", None), "brokerVersion","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.jndiname", None), "jndiName","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.expiry", None), "expiry","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.brokerccdursubqueue", None), "brokerCCDurSubQueue","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.multicast", None), "multicast","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.messagebody", None), "messageBody","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.persistence", None), "persistence","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.mqmdmessagecontext", None), "mqmdMessageContext","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.providertype", None), "providerType","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.floatingpointencoding", None), "floatingPointEncoding","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.receiveccsid", None), "receiveCCSID","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.brokerdursubqueue", None), "brokerDurSubQueue","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.readahead", None), "readAhead","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.decimalencoding", None), "decimalEncoding","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.targetclient", None), "targetClient","MQTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqtopic.readaheadclose", None), "readAheadClose","MQTopic");
  if len(atts) != 0:
    print "Modifying MQTopic with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQTopic configuration up to date.";

  Util.popPathElement('MQTopic');
