from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util
from ManagementScope import ManagementScope

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('ManagementScopeRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereManagementScopeRef");
  exportedObject.put("roleName", "WebSphereManagementScopeRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managementscoperef.scopename", objid, "scopeName","ManagementScope");
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ManagementScopeRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('ManagementScopeRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagementScopeRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.managementscoperef.scopename'):
    raise Exception("ManagementScopeRef resource has no property named websphere.managementscoperef.scopename!");

  scopeName = roleProperties.getString('websphere.managementscoperef.scopename')

  managementScopeId = None;
  managementScopes = Util.getid("/ManagementScope:/").splitlines();
  if len(managementScopes) > 0:
    for managementScope in managementScopes:
      if len(managementScope) > 0:
        managementScopeName = Util.getRequiredAttribute(managementScope, "scopeName", "ManagementScope" );
        
        if (scopeName == managementScopeName):
          managementScopeId = managementScope;
          break;
  
  if managementScopeId is None or len(managementScopeId) < 1:
    scopeType = scopeName[scopeName.rfind("(")+1:scopeName.rfind(")")];
    args = [];
    args.append(['scopeName', scopeName]);
    args.append(['scopeType', scopeType]);
    Log.log("Could not find management scope named %(name)s. Creating.." % { 'name':scopeName } );
    managementScopeId = Util.create('ManagementScope', Util.getid("/Security:/"), args, None, 1);

  properties = [];
  properties.append([parentAtt, managementScopeId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating ManagementScopeRef to %(id)s for attribute %(att)s" % { 'id':managementScopeId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating ManagementScopeRef to %(id)s for attribute %(att)s" % { 'id':managementScopeId, 'att':parentAtt });
  Util.popPathElement('ManagementScopeRef');
