from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthForeignDestination')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthForeignDestination");
  exportedObject.put("roleName", "WebSphereSIBAuthForeignDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeigndestination.busname", objid, "busName","SIBAuthForeignDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeigndestination.destinationname", objid, "destinationName","SIBAuthForeignDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthForeignDestination');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthForeignDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibauthforeigndestination.busname", None));
  Util.addIfNotNone(properties, "destinationName", roleProperties.optString("websphere.sibauthforeigndestination.destinationname", None));
  print "Creating SIBAuthForeignDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthForeignDestination", parentid, properties);
  Util.popPathElement('SIBAuthForeignDestination');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthForeignDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeigndestination.busname", None), "busName","SIBAuthForeignDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeigndestination.destinationname", None), "destinationName","SIBAuthForeignDestination");
  if len(atts) != 0:
    print "Modifying SIBAuthForeignDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthForeignDestination configuration up to date.";

  Util.popPathElement('SIBAuthForeignDestination');
