from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthQueue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthQueue");
  exportedObject.put("roleName", "WebSphereSIBAuthQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthqueue.inheritdefaults", objid, "inheritDefaults","SIBAuthQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthqueue.identifier", objid, "identifier","SIBAuthQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthQueue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthqueue.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthqueue.identifier", None));
  print "Creating SIBAuthQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthQueue", parentid, properties);
  Util.popPathElement('SIBAuthQueue');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthqueue.inheritdefaults", None), "inheritDefaults","SIBAuthQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthqueue.identifier", None), "identifier","SIBAuthQueue");
  if len(atts) != 0:
    print "Modifying SIBAuthQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthQueue configuration up to date.";

  Util.popPathElement('SIBAuthQueue');
