from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthUser import SIBAuthUser

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthSpace')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthSpace");
  exportedObject.put("roleName", "WebSphereSIBAuthSpace");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  
  typeFolders = {};  

  i = 0;
  sibAuthUsers = Util.parseConfigIdListAttribute(objid, 'user',"SIBAuthSpace");
  for sibAuthUser in sibAuthUsers:
    if len(sibAuthUser) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthUser", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthUser._export(sibAuthUser, currespath, "SIBAuthUser%s" % i));
      i = i + 1;
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthSpace');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthSpace')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthSpace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SIBAuthSpace with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthSpace", parentid, properties);
  
  sibAuthUsers = Util.parseConfigIdListAttribute(objid, 'user',"SIBAuthSpace");
  for sibAuthUser in sibAuthUsers:
    if len(sibAuthUser) > 0:
      Util.remove(sibAuthUser);
      
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBAuthUser":
        SIBAuthUser.create(objid, curjsonobject);      
  Util.popPathElement('SIBAuthSpace');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthSpace')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthSpace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SIBAuthSpace with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthSpace configuration up to date.";

  sibAuthUsers = Util.parseConfigIdListAttribute(objid, 'user',"SIBAuthSpace");
  for sibAuthUser in sibAuthUsers:
    if len(sibAuthUser) > 0:
      Util.remove(sibAuthUser);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBAuthUser":
        SIBAuthUser.create(objid, curjsonobject);  
  Util.popPathElement('SIBAuthSpace');

def getSIBAuthSpaces(objid):
  sibAuthSpaces = Util.getAssociatedObjects(objid, "SIBAuthSpace");
  return sibAuthSpaces;         
