from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthTopic')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthTopic");
  exportedObject.put("roleName", "WebSphereSIBAuthTopic");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.inheritreceiver", objid, "inheritReceiver","SIBAuthTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.identifier", objid, "identifier","SIBAuthTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.inheritsender", objid, "inheritSender","SIBAuthTopic");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthTopic');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritReceiver", roleProperties.optString("websphere.sibauthtopic.inheritreceiver", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthtopic.identifier", None));
  Util.addIfNotNone(properties, "inheritSender", roleProperties.optString("websphere.sibauthtopic.inheritsender", None));
  print "Creating SIBAuthTopic with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthTopic", parentid, properties);
  Util.popPathElement('SIBAuthTopic');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.inheritreceiver", None), "inheritReceiver","SIBAuthTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.identifier", None), "identifier","SIBAuthTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.inheritsender", None), "inheritSender","SIBAuthTopic");
  if len(atts) != 0:
    print "Modifying SIBAuthTopic with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthTopic configuration up to date.";

  Util.popPathElement('SIBAuthTopic');
