from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDestinationAlias')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDestinationAlias");
  exportedObject.put("roleName", "WebSphereSIBDestinationAlias");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.sibdestinationalias.targetqueuepointidentifiers", objid, "targetQueuePointIdentifiers","SIBDestinationAlias");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.sibdestinationalias.targetmediationpointidentifiers", objid, "targetMediationPointIdentifiers","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.delegateauthorizationchecktotarget", objid, "delegateAuthorizationCheckToTarget","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.receiveallowed", objid, "receiveAllowed","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.defaultpriority", objid, "defaultPriority","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.identifier", objid, "identifier","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.instancetype", objid, "instanceType","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.maxreliability", objid, "maxReliability","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.overrideofqosbyproducerallowed", objid, "overrideOfQOSByProducerAllowed","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.targetidentifier", objid, "targetIdentifier","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.targetbus", objid, "targetBus","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.bus", objid, "bus","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.reliability", objid, "reliability","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.description", objid, "description","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.alltargetqueuepointsselected", objid, "allTargetQueuePointsSelected","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.uuid", objid, "uuid","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.alltargetmediationpointsselected", objid, "allTargetMediationPointsSelected","SIBDestinationAlias");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationalias.sendallowed", objid, "sendAllowed","SIBDestinationAlias");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDestinationAlias');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDestinationAlias')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationAlias resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "targetQueuePointIdentifiers", roleProperties.optString("websphere.sibdestinationalias.targetqueuepointidentifiers", None));
  Util.addPathProperty(properties, "targetMediationPointIdentifiers", roleProperties.optString("websphere.sibdestinationalias.targetmediationpointidentifiers", None));
  Util.addIfNotNone(properties, "delegateAuthorizationCheckToTarget", roleProperties.optString("websphere.sibdestinationalias.delegateauthorizationchecktotarget", None));
  Util.addIfNotNone(properties, "receiveAllowed", roleProperties.optString("websphere.sibdestinationalias.receiveallowed", None));
  Util.addIfNotNone(properties, "defaultPriority", roleProperties.optString("websphere.sibdestinationalias.defaultpriority", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibdestinationalias.identifier", None));
  Util.addIfNotNone(properties, "instanceType", roleProperties.optString("websphere.sibdestinationalias.instancetype", None));
  Util.addIfNotNone(properties, "maxReliability", roleProperties.optString("websphere.sibdestinationalias.maxreliability", None));
  Util.addIfNotNone(properties, "overrideOfQOSByProducerAllowed", roleProperties.optString("websphere.sibdestinationalias.overrideofqosbyproducerallowed", None));
  Util.addIfNotNone(properties, "targetIdentifier", roleProperties.optString("websphere.sibdestinationalias.targetidentifier", None));
  Util.addIfNotNone(properties, "targetBus", roleProperties.optString("websphere.sibdestinationalias.targetbus", None));
  Util.addIfNotNone(properties, "bus", roleProperties.optString("websphere.sibdestinationalias.bus", None));
  Util.addIfNotNone(properties, "reliability", roleProperties.optString("websphere.sibdestinationalias.reliability", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibdestinationalias.description", None));
  Util.addIfNotNone(properties, "allTargetQueuePointsSelected", roleProperties.optString("websphere.sibdestinationalias.alltargetqueuepointsselected", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibdestinationalias.uuid", None));
  Util.addIfNotNone(properties, "allTargetMediationPointsSelected", roleProperties.optString("websphere.sibdestinationalias.alltargetmediationpointsselected", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibdestinationalias.sendallowed", None));
  print "Creating SIBDestinationAlias with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDestinationAlias", parentid, properties);
  Util.popPathElement('SIBDestinationAlias');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDestinationAlias')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationAlias resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.targetqueuepointidentifiers", None), "targetQueuePointIdentifiers","SIBDestinationAlias");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.targetmediationpointidentifiers", None), "targetMediationPointIdentifiers","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.delegateauthorizationchecktotarget", None), "delegateAuthorizationCheckToTarget","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.receiveallowed", None), "receiveAllowed","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.defaultpriority", None), "defaultPriority","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.identifier", None), "identifier","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.instancetype", None), "instanceType","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.maxreliability", None), "maxReliability","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.overrideofqosbyproducerallowed", None), "overrideOfQOSByProducerAllowed","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.targetidentifier", None), "targetIdentifier","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.targetbus", None), "targetBus","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.bus", None), "bus","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.reliability", None), "reliability","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.description", None), "description","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.alltargetqueuepointsselected", None), "allTargetQueuePointsSelected","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.uuid", None), "uuid","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.alltargetmediationpointsselected", None), "allTargetMediationPointsSelected","SIBDestinationAlias");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationalias.sendallowed", None), "sendAllowed","SIBDestinationAlias");
  if len(atts) != 0:
    print "Modifying SIBDestinationAlias with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDestinationAlias configuration up to date.";
  Util.popPathElement('SIBDestinationAlias');
    
def getSIBDestinationAlias(objid):
  sibDestinationAlias = Util.getAssociatedObjects(objid, "SIBDestinationAlias");
  return sibDestinationAlias;       

