from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WebserverPluginSettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWebserverPluginSettings");
  exportedObject.put("roleName", "WebSphereWebserverPluginSettings");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.extendedhandshake", objid, "ExtendedHandshake","WebserverPluginSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.connecttimeout", objid, "ConnectTimeout","WebserverPluginSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.waitforcontinue", objid, "WaitForContinue","WebserverPluginSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.serveriotimeout", objid, "ServerIOTimeout","WebserverPluginSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.role", objid, "Role","WebserverPluginSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webserverpluginsettings.maxconnections", objid, "MaxConnections","WebserverPluginSettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WebserverPluginSettings");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WebserverPluginSettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WebserverPluginSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebserverPluginSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ExtendedHandshake", roleProperties.optString("websphere.webserverpluginsettings.extendedhandshake", None));
  Util.addIfNotNone(properties, "ConnectTimeout", roleProperties.optString("websphere.webserverpluginsettings.connecttimeout", None));
  Util.addIfNotNone(properties, "WaitForContinue", roleProperties.optString("websphere.webserverpluginsettings.waitforcontinue", None));
  Util.addIfNotNone(properties, "ServerIOTimeout", roleProperties.optString("websphere.webserverpluginsettings.serveriotimeout", None));
  Util.addIfNotNone(properties, "Role", roleProperties.optString("websphere.webserverpluginsettings.role", None));
  Util.addIfNotNone(properties, "MaxConnections", roleProperties.optString("websphere.webserverpluginsettings.maxconnections", None));
  print "Creating WebserverPluginSettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WebserverPluginSettings", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WebserverPluginSettings');

def update(objid,jsonobject):
  Util.pushPathElement('WebserverPluginSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebserverPluginSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.extendedhandshake", None), "ExtendedHandshake","WebserverPluginSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.connecttimeout", None), "ConnectTimeout","WebserverPluginSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.waitforcontinue", None), "WaitForContinue","WebserverPluginSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.serveriotimeout", None), "ServerIOTimeout","WebserverPluginSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.role", None), "Role","WebserverPluginSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webserverpluginsettings.maxconnections", None), "MaxConnections","WebserverPluginSettings");
  if len(atts) != 0:
    print "Modifying WebserverPluginSettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WebserverPluginSettings configuration up to date.";

  Property.removeProperties(objid, 'properties',"WebserverPluginSettings");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WebserverPluginSettings');
