from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.workmanagerprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WorkManagerProvider');

  containmentpath = "%(parentconpath)sWorkManagerProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WorkManagerProvider')

  name = Util.getRequiredAttribute(objid, "name", 'WorkManagerProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkManagerProvider");
  exportedObject.put("roleName", "WebSphereWorkManagerProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.workmanagerprovider.classpath", objid, "classpath","WorkManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerprovider.name", objid, "name","WorkManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerprovider.isolatedclassloader", objid, "isolatedClassLoader","WorkManagerProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.workmanagerprovider.nativepath", objid, "nativepath","WorkManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerprovider.description", objid, "description","WorkManagerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workmanagerprovider.providertype", objid, "providerType","WorkManagerProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkManagerProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.workmanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create WorkManagerProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkManagerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workmanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.workmanagerprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workmanagerprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.workmanagerprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.workmanagerprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.workmanagerprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.workmanagerprovider.providertype", None));
  print "Creating WorkManagerProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkManagerProvider", parentid, properties);
  Util.popPathElement('WorkManagerProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WorkManagerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkManagerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workmanagerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.workmanagerprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.classpath", None), "classpath","WorkManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.name", None), "name","WorkManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.isolatedclassloader", None), "isolatedClassLoader","WorkManagerProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.nativepath", None), "nativepath","WorkManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.description", None), "description","WorkManagerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workmanagerprovider.providertype", None), "providerType","WorkManagerProvider");
  if len(atts) != 0:
    print "Modifying WorkManagerProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkManagerProvider configuration up to date.";

  Util.popPathElement('WorkManagerProvider');
