from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from KeyStoreRef import KeyStoreRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CACertificate')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCACertificate");
  exportedObject.put("roleName", "WebSphereCACertificate");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cacertificate.alias", objid, "alias","CACertificate");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cacertificate.pollingstatus", objid, "pollingStatus","CACertificate");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  keyStore = Util.getOptionalAttribute(objid, 'keyStore', 'CACertificate');
  if keyStore is not None and len(keyStore) > 0:
    returndict = Util.createTypeFolder(respath, "KeyStoreRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, KeyStoreRef._export(keyStore, currespath, "KeyStore"));  
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CACertificate');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CACertificate')
  if not jsonobject.has("roleProperties"):
    raise Exception("CACertificate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.cacertificate.alias", None));
  Util.addIfNotNone(properties, "pollingStatus", roleProperties.optString("websphere.cacertificate.pollingstatus", None));
  print "Creating CACertificate with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CACertificate", parentid, properties);
  
  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereKeyStoreRef":
        KeyStoreRef.create(objid, currjsonobject, "keyStore");  
  Util.popPathElement('CACertificate');

def update(objid,jsonobject):
  Util.pushPathElement('CACertificate')
  if not jsonobject.has("roleProperties"):
    raise Exception("CACertificate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cacertificate.alias", None), "alias","CACertificate");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cacertificate.pollingstatus", None), "pollingStatus","CACertificate");
  if len(atts) != 0:
    print "Modifying CACertificate with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CACertificate configuration up to date.";
    
  Util.unsetAttribute(objid, "keyStore", "CACertificate");

  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereKeyStoreRef":
        KeyStoreRef.create(objid, currjsonobject, "keyStore");    

  Util.popPathElement('CACertificate');
