from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMediation')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMediation");
  exportedObject.put("roleName", "WebSphereSIBMediation");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediation.handlerlistname", objid, "handlerListName","SIBMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediation.uuid", objid, "uuid","SIBMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediation.description", objid, "description","SIBMediation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediation.mediationname", objid, "mediationName","SIBMediation");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMediation');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMediation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "handlerListName", roleProperties.optString("websphere.sibmediation.handlerlistname", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmediation.uuid", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibmediation.description", None));
  Util.addIfNotNone(properties, "mediationName", roleProperties.optString("websphere.sibmediation.mediationname", None));
  print "Creating SIBMediation with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMediation", parentid, properties);
  Util.popPathElement('SIBMediation');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMediation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediation.handlerlistname", None), "handlerListName","SIBMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediation.uuid", None), "uuid","SIBMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediation.description", None), "description","SIBMediation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediation.mediationname", None), "mediationName","SIBMediation");
  if len(atts) != 0:
    print "Modifying SIBMediation with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMediation configuration up to date.";

  Util.popPathElement('SIBMediation');
