from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBQualifiedDestinationName')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBQualifiedDestinationName");
  exportedObject.put("roleName", "WebSphereSIBQualifiedDestinationName");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqualifieddestinationname.destination", objid, "destination","SIBQualifiedDestinationName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqualifieddestinationname.bus", objid, "bus","SIBQualifiedDestinationName");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBQualifiedDestinationName');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBQualifiedDestinationName')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBQualifiedDestinationName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "destination", roleProperties.optString("websphere.sibqualifieddestinationname.destination", None));
  Util.addIfNotNone(properties, "bus", roleProperties.optString("websphere.sibqualifieddestinationname.bus", None));
  print "Creating SIBQualifiedDestinationName with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBQualifiedDestinationName", parentid, properties);
  Util.popPathElement('SIBQualifiedDestinationName');

def update(objid,jsonobject):
  Util.pushPathElement('SIBQualifiedDestinationName')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBQualifiedDestinationName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqualifieddestinationname.destination", None), "destination","SIBQualifiedDestinationName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqualifieddestinationname.bus", None), "bus","SIBQualifiedDestinationName");
  if len(atts) != 0:
    print "Modifying SIBQualifiedDestinationName with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBQualifiedDestinationName configuration up to date.";

  Util.popPathElement('SIBQualifiedDestinationName');
