from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from SecurityDomain import SecurityDomain

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityDomainMember')

  attName = Util.getRequiredAttribute(objid, "name", 'SecurityDomainMember'); 
  if attName is not None and len(attName) > 0:
    name = attName;

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityDomainMember");
  exportedObject.put("roleName", "WebSphereSecurityDomainMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.name", objid, "name","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.resourcename", objid, "resourceName","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.resourcetype", objid, "resourceType","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.description", objid, "description","SecurityDomainMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SecurityDomainMember");

  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      returndict = Util.createTypeFolder(respath, "SecurityDomain", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SecurityDomain._export(securityDomain, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityDomainMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityDomainMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityDomainMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNoneOrEmpty(properties, "name", roleProperties.optString("websphere.securitydomainmember.name", None));
  Util.addIfNotNone(properties, "resourceName", roleProperties.optString("websphere.securitydomainmember.resourcename", None));
  Util.addIfNotNone(properties, "resourceType", roleProperties.optString("websphere.securitydomainmember.resourcetype", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.securitydomainmember.description", None));
  print "Creating SecurityDomainMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityDomainMember", parentid, properties);

  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      Util.remove(securityDomain);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomain":
          SecurityDomain.create(objid, curjsonobject);
  Util.popPathElement('SecurityDomainMember');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityDomainMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityDomainMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.name", None), "name","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.resourcename", None), "resourceName","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.resourcetype", None), "resourceType","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.description", None), "description","SecurityDomainMember");
  if len(atts) != 0:
    print "Modifying SecurityDomainMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecurityDomainMember configuration up to date.";

  Property.removeProperties(objid, 'properties',"SecurityDomainMember");

  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      Util.remove(securityDomain);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomain":
          SecurityDomain.create(objid, curjsonobject);
  Util.popPathElement('SecurityDomainMember');
