from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscbnd.PortQnameBinding");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscbnd.PortQnameBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamelocalnamelink", objid, "portQnameLocalNameLink","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamenamespacelink", objid, "portQnameNamespaceLink","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenbindingnamespace", objid, "overriddenBindingNamespace","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenendpointuri", objid, "overriddenEndpointURI","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.synctimeout", objid, "syncTimeout","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.PortQnameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "portQnameLocalNameLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamelocalnamelink", None));
  Util.addIfNotNone(properties, "portQnameNamespaceLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamenamespacelink", None));
  Util.addIfNotNone(properties, "overriddenBindingNamespace", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenbindingnamespace", None));
  Util.addIfNotNone(properties, "overriddenEndpointURI", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenendpointuri", None));
  Util.addIfNotNone(properties, "syncTimeout", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.synctimeout", None));
  print "Creating com.ibm.etools.webservice.wscbnd.PortQnameBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscbnd.PortQnameBinding", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.PortQnameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamelocalnamelink", None), "portQnameLocalNameLink","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.portqnamenamespacelink", None), "portQnameNamespaceLink","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenbindingnamespace", None), "overriddenBindingNamespace","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.overriddenendpointuri", None), "overriddenEndpointURI","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.portqnamebinding.synctimeout", None), "syncTimeout","com.ibm.etools.webservice.wscbnd.PortQnameBinding");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscbnd.PortQnameBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscbnd.PortQnameBinding configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscbnd.PortQnameBinding');
