from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AgeCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAgeCondition");
  exportedObject.put("roleName", "WebSphereAgeCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.agecondition.name", objid, "name","AgeCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.agecondition.maxage", objid, "maxAge","AgeCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.agecondition.conditionexpr", objid, "conditionExpr","AgeCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.agecondition.ageunits", objid, "ageUnits","AgeCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AgeCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AgeCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("AgeCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.agecondition.name", None));
  Util.addIfNotNone(properties, "maxAge", roleProperties.optString("websphere.agecondition.maxage", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.agecondition.conditionexpr", None));
  Util.addIfNotNone(properties, "ageUnits", roleProperties.optString("websphere.agecondition.ageunits", None));
  print "Creating AgeCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AgeCondition", parentid, properties);
  Util.popPathElement('AgeCondition');

def update(objid,jsonobject):
  Util.pushPathElement('AgeCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("AgeCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.agecondition.name", None), "name","AgeCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.agecondition.maxage", None), "maxAge","AgeCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.agecondition.conditionexpr", None), "conditionExpr","AgeCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.agecondition.ageunits", None), "ageUnits","AgeCondition");
  if len(atts) != 0:
    print "Modifying AgeCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AgeCondition configuration up to date.";

  Util.popPathElement('AgeCondition');
