from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomHealthAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomHealthAction");
  exportedObject.put("roleName", "WebSphereCustomHealthAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customhealthaction.actionname", objid, "actionName","CustomHealthAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customhealthaction.actiontype", objid, "actionType","CustomHealthAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customhealthaction.targetserver", objid, "targetServer","CustomHealthAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customhealthaction.targetnode", objid, "targetNode","CustomHealthAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customhealthaction.stepnum", objid, "stepNum","CustomHealthAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomHealthAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomHealthAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomHealthAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "actionName", roleProperties.optString("websphere.customhealthaction.actionname", None));
  Util.addIfNotNone(properties, "actionType", roleProperties.optString("websphere.customhealthaction.actiontype", None));
  Util.addIfNotNone(properties, "targetServer", roleProperties.optString("websphere.customhealthaction.targetserver", None));
  Util.addIfNotNone(properties, "targetNode", roleProperties.optString("websphere.customhealthaction.targetnode", None));
  Util.addIfNotNone(properties, "stepNum", roleProperties.optString("websphere.customhealthaction.stepnum", None));
  print "Creating CustomHealthAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomHealthAction", parentid, properties);
  Util.popPathElement('CustomHealthAction');

def update(objid,jsonobject):
  Util.pushPathElement('CustomHealthAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomHealthAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customhealthaction.actionname", None), "actionName","CustomHealthAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customhealthaction.actiontype", None), "actionType","CustomHealthAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customhealthaction.targetserver", None), "targetServer","CustomHealthAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customhealthaction.targetnode", None), "targetNode","CustomHealthAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customhealthaction.stepnum", None), "stepNum","CustomHealthAction");
  if len(atts) != 0:
    print "Modifying CustomHealthAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomHealthAction configuration up to date.";

  Util.popPathElement('CustomHealthAction');
