from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.httpresponsecompressionactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPResponseCompressionActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "HTTPResponseCompressionAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered HTTPResponseCompressionActionRef");
  exportedObject.put("roleName", "WebSphereHTTPResponseCompressionActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpresponsecompressionactionref.name", objid, "name","HTTPResponseCompressionAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPResponseCompressionActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereHTTPResponseCompressionActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.httpresponsecompressionactionref.name"):
    raise Exception("Resource role properties does not contain websphere.httpresponsecompressionactionref.name!");

  httpResponseCompressionActionRefName = roleProperties.optString("websphere.httpresponsecompressionactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/HTTPResponseCompressionAction:" + httpResponseCompressionActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/HTTPResponseCompressionAction:" + httpResponseCompressionActionRefName + "/";
  httpResponseCompressionAction = Util.getid(containmentPath);
  if httpResponseCompressionAction == None or len(httpResponseCompressionAction) == 0:
      raise Exception("Could not determine the HTTP Response Compression Action for HTTPResponseCompressionActionRef " + httpResponseCompressionActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', httpResponseCompressionAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
