from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from J2EEResourceProperty import J2EEResourceProperty
from ActivationSpecRef import ActivationSpecRef

__name_att__ = "websphere.j2cactivationspec.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'J2CActivationSpec');

  containmentpath = "%(parentconpath)sJ2CActivationSpec:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('J2CActivationSpec')

  if name == None or len(name) == 0:
    name = Util.getRequiredAttribute(objid, "name", 'J2CActivationSpec');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2CActivationSpec");
  exportedObject.put("roleName", "WebSphereJ2CActivationSpec");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cactivationspec.destinationjndiname", objid, "destinationJndiName","J2CActivationSpec");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cactivationspec.name", objid, "name","J2CActivationSpec");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cactivationspec.authenticationalias", objid, "authenticationAlias","J2CActivationSpec");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cactivationspec.description", objid, "description","J2CActivationSpec");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cactivationspec.jndiname", objid, "jndiName","J2CActivationSpec");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'J2CActivationSpec');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  activationSpec = Util.getOptionalAttribute(objid, 'activationSpec', 'J2CActivationSpec');
  if activationSpec is not None and len(activationSpec) > 0:
    returndict = Util.createTypeFolder(respath, "ActivationSpecRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    activationSpecName = Util.getRequiredAttribute(activationSpec, "activationSpecClass", "ActivationSpec" );
    Util.addAllFromExport(extraObjects, ActivationSpecRef._export(activationSpec, currespath, activationSpecName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2CActivationSpec');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CActivationSpec resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.j2cactivationspec.name"):
    raise Exception("Resource role properties does not contain websphere.j2cactivationspec.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create J2CActivationSpec on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('J2CActivationSpec')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CActivationSpec resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.j2cactivationspec.name"):
    raise Exception("Resource role properties does not contain websphere.j2cactivationspec.name!");

  properties = [];
  Util.addIfNotNone(properties, "destinationJndiName", roleProperties.optString("websphere.j2cactivationspec.destinationjndiname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.j2cactivationspec.name", None));
  Util.addIfNotNone(properties, "authenticationAlias", roleProperties.optString("websphere.j2cactivationspec.authenticationalias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.j2cactivationspec.description", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.j2cactivationspec.jndiname", None));

  # The referenced ActivationSpec needs to be added as a property during create
  # So, we are doing things a little out of order here.
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereActivationSpecRef":
        referencedActivationSpec = ActivationSpecRef.getReferencedActivationSpec(parentid, curjsonobject);
        Util.addIfNotNone(properties, "activationSpec", referencedActivationSpec);
        break;

  print "Creating J2CActivationSpec with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

  objid = Util.create("J2CActivationSpec", parentid, properties);

  # J2CActivationSpec inherits the J2EEResourceProperties from ActivationSpecTemplateProps on creation.
  # So, let's remove the inherited J2EEResourceProperties and add the ones from the resource tree.
  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'J2CActivationSpec');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
  Util.popPathElement('J2CActivationSpec');
  return objid;

def findAndUpdate(parentid, jsonobject, objtype, targetpropertyname, attribute):
  childToUpdate = Util.findChildToUpdate(parentid, jsonobject, objtype, targetpropertyname, attribute);
  update(childToUpdate, jsonobject);

def update(objid,jsonobject):
  Util.pushPathElement('J2CActivationSpec')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CActivationSpec resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.j2cactivationspec.name"):
    raise Exception("Resource role properties does not contain websphere.j2cactivationspec.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cactivationspec.destinationjndiname", None), "destinationJndiName","J2CActivationSpec");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cactivationspec.name", None), "name","J2CActivationSpec");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cactivationspec.authenticationalias", None), "authenticationAlias","J2CActivationSpec");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cactivationspec.description", None), "description","J2CActivationSpec");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cactivationspec.jndiname", None), "jndiName","J2CActivationSpec");
  if len(atts) != 0:
    print "Modifying J2CActivationSpec with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2CActivationSpec configuration up to date.";

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'J2CActivationSpec');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereActivationSpecRef":
        ActivationSpecRef.doImport(objid, curjsonobject);
  Util.popPathElement('J2CActivationSpec');
