from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JAXRPCHeader')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAXRPCHeader");
  exportedObject.put("roleName", "WebSphereJAXRPCHeader");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxrpcheader.localpart", objid, "localPart","JAXRPCHeader");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxrpcheader.namespaceuri", objid, "namespaceURI","JAXRPCHeader");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAXRPCHeader');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAXRPCHeader')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXRPCHeader resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "localPart", roleProperties.optString("websphere.jaxrpcheader.localpart", None));
  Util.addIfNotNone(properties, "namespaceURI", roleProperties.optString("websphere.jaxrpcheader.namespaceuri", None));
  print "Creating JAXRPCHeader with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAXRPCHeader", parentid, properties);
  Util.popPathElement('JAXRPCHeader');

def update(objid,jsonobject):
  Util.pushPathElement('JAXRPCHeader')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXRPCHeader resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxrpcheader.localpart", None), "localPart","JAXRPCHeader");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxrpcheader.namespaceuri", None), "namespaceURI","JAXRPCHeader");
  if len(atts) != 0:
    print "Modifying JAXRPCHeader with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAXRPCHeader configuration up to date.";

  Util.popPathElement('JAXRPCHeader');
