from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from MatchCriteria import MatchCriteria 
from Property import Property
from utilities import Util

__name_att__ = "websphere.nooppolicy.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'NoOpPolicy');

  containmentpath = "%(parentconpath)sNoOpPolicy:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('NoOpPolicy')

  name = Util.getRequiredAttribute(objid, "name", 'NoOpPolicy');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereNoOpPolicy");
  exportedObject.put("roleName", "WebSphereNoOpPolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nooppolicy.quorumenabled", objid, "quorumEnabled","NoOpPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nooppolicy.isaliveperiodsec", objid, "isAlivePeriodSec","NoOpPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nooppolicy.policyfactory", objid, "policyFactory","NoOpPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nooppolicy.name", objid, "name","NoOpPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nooppolicy.description", objid, "description","NoOpPolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  first = 0;
  matchcriterias = Util.parseConfigIdListAttribute(objid, 'MatchCriteria',"NoOpPolicy");
  for criteria in matchcriterias:
    returndict = Util.createTypeFolder(respath, "MatchCriteria", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MatchCriteria._export(criteria, currespath));

  extraObjects = Property.exportProperties(objid,respath,extraObjects,typeFolders,'customProperties',"NoOpPolicy");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('NoOpPolicy');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("NoOpPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.nooppolicy.name"):
    raise Exception("Resource role properties does not contain websphere.nooppolicy.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create NoOpPolicy on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('NoOpPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("NoOpPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.nooppolicy.name"):
    raise Exception("Resource role properties does not contain websphere.nooppolicy.name!");

  properties = [];
  Util.addIfNotNone(properties, "quorumEnabled", roleProperties.optString("websphere.nooppolicy.quorumenabled", None));
  Util.addIfNotNone(properties, "isAlivePeriodSec", roleProperties.optString("websphere.nooppolicy.isaliveperiodsec", None));
  Util.addIfNotNone(properties, "policyFactory", roleProperties.optString("websphere.nooppolicy.policyfactory", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.nooppolicy.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.nooppolicy.description", None));
  print "Creating NoOpPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("NoOpPolicy", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject ==  0):
        if currole == "WebSphereMatchCriteria":
          MatchCriteria.create(objid, curjsonobject);
  Util.popPathElement('NoOpPolicy');
  return objid;


def update(objid,jsonobject):
  Util.pushPathElement('NoOpPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("NoOpPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.nooppolicy.name"):
    raise Exception("Resource role properties does not contain websphere.nooppolicy.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nooppolicy.quorumenabled", None), "quorumEnabled","NoOpPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nooppolicy.isaliveperiodsec", None), "isAlivePeriodSec","NoOpPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nooppolicy.policyfactory", None), "policyFactory","NoOpPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nooppolicy.name", None), "name","NoOpPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nooppolicy.description", None), "description","NoOpPolicy");
  if len(atts) != 0:
    print "Modifying NoOpPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "NoOpPolicy configuration up to date.";

  Util.modify(objid, [['MatchCriteria','']]);
  Property.removeProperties(objid, 'customProperties',"NoOpPolicy");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject ==  0):
        if currole == "WebSphereMatchCriteria":
          MatchCriteria.create(objid, curjsonobject);
  Util.popPathElement('NoOpPolicy');
