from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ObjectPool')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereObjectPool");
  exportedObject.put("roleName", "WebSphereObjectPool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpool.poolclassname", objid, "poolClassName","ObjectPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpool.poolimplclassname", objid, "poolImplClassName","ObjectPool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ObjectPool");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ObjectPool');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ObjectPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "poolClassName", roleProperties.optString("websphere.objectpool.poolclassname", None));
  Util.addIfNotNone(properties, "poolImplClassName", roleProperties.optString("websphere.objectpool.poolimplclassname", None));
  print "Creating ObjectPool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ObjectPool", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ObjectPool');

def update(objid,jsonobject):
  Util.pushPathElement('ObjectPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpool.poolclassname", None), "poolClassName","ObjectPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpool.poolimplclassname", None), "poolImplClassName","ObjectPool");
  if len(atts) != 0:
    print "Modifying ObjectPool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ObjectPool configuration up to date.";

  Property.removeProperties(objid, 'properties',"ObjectPool");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ObjectPool');
