from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('OutputRedirect')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereOutputRedirect");
  exportedObject.put("roleName", "WebSphereOutputRedirect");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.outputredirect.stdinfilename", objid, "stdinFilename","OutputRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.outputredirect.stderrfilename", objid, "stderrFilename","OutputRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.outputredirect.stdoutfilename", objid, "stdoutFilename","OutputRedirect");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('OutputRedirect');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('OutputRedirect')
  if not jsonobject.has("roleProperties"):
    raise Exception("OutputRedirect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "stdinFilename", roleProperties.optString("websphere.outputredirect.stdinfilename", None));
  Util.addIfNotNone(properties, "stderrFilename", roleProperties.optString("websphere.outputredirect.stderrfilename", None));
  Util.addIfNotNone(properties, "stdoutFilename", roleProperties.optString("websphere.outputredirect.stdoutfilename", None));
  print "Creating OutputRedirect with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("OutputRedirect", parentid, properties);
  Util.popPathElement('OutputRedirect');

def update(objid,jsonobject):
  Util.pushPathElement('OutputRedirect')
  if not jsonobject.has("roleProperties"):
    raise Exception("OutputRedirect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.outputredirect.stdinfilename", None), "stdinFilename","OutputRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.outputredirect.stderrfilename", None), "stderrFilename","OutputRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.outputredirect.stdoutfilename", None), "stdoutFilename","OutputRedirect");
  if len(atts) != 0:
    print "Modifying OutputRedirect with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "OutputRedirect configuration up to date.";

  Util.popPathElement('OutputRedirect');
