from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthReceiver import SIBAuthReceiver;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthTopicSpaceBase')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthTopicSpaceBase");
  exportedObject.put("roleName", "WebSphereSIBAuthTopicSpaceBase");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthTopicSpaceBase');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthTopicSpaceBase');
  if receiver is not None and len(receiver) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthReceiver", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthReceiver._export(receiver, currespath, "SIBAuthReceiver"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthTopicSpaceBase');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthTopicSpaceBase');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthTopicSpaceBase')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopicSpaceBase resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SIBAuthTopicSpaceBase with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthTopicSpaceBase", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthTopicSpaceBase');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthTopicSpaceBase')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopicSpaceBase resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SIBAuthTopicSpaceBase with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthTopicSpaceBase configuration up to date.";

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthTopicSpaceBase');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthTopicSpaceBase');
  if receiver is not None and len(receiver) > 0:
    Util.remove(receiver);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthTopicSpaceBase');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthTopicSpaceBase');
