from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSUDDIPublication')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSUDDIPublication");
  exportedObject.put("roleName", "WebSphereSIBWSUDDIPublication");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.name", objid, "name","SIBWSUDDIPublication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.description", objid, "description","SIBWSUDDIPublication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.wsdlservinghttpurlroot", objid, "WSDLServingHTTPURLRoot","SIBWSUDDIPublication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.uddirefname", objid, "UDDIRefName","SIBWSUDDIPublication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.uddiservicekey", objid, "UDDIServiceKey","SIBWSUDDIPublication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsuddipublication.uddibusinesskey", objid, "UDDIBusinessKey","SIBWSUDDIPublication");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSUDDIPublication');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSUDDIPublication')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSUDDIPublication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsuddipublication.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsuddipublication.description", None));
  Util.addIfNotNone(properties, "WSDLServingHTTPURLRoot", roleProperties.optString("websphere.sibwsuddipublication.wsdlservinghttpurlroot", None));
  Util.addIfNotNone(properties, "UDDIRefName", roleProperties.optString("websphere.sibwsuddipublication.uddirefname", None));
  Util.addIfNotNone(properties, "UDDIServiceKey", roleProperties.optString("websphere.sibwsuddipublication.uddiservicekey", None));
  Util.addIfNotNone(properties, "UDDIBusinessKey", roleProperties.optString("websphere.sibwsuddipublication.uddibusinesskey", None));
  print "Creating SIBWSUDDIPublication with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSUDDIPublication", parentid, properties);
  Util.popPathElement('SIBWSUDDIPublication');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSUDDIPublication')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSUDDIPublication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.name", None), "name","SIBWSUDDIPublication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.description", None), "description","SIBWSUDDIPublication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.wsdlservinghttpurlroot", None), "WSDLServingHTTPURLRoot","SIBWSUDDIPublication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.uddirefname", None), "UDDIRefName","SIBWSUDDIPublication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.uddiservicekey", None), "UDDIServiceKey","SIBWSUDDIPublication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsuddipublication.uddibusinesskey", None), "UDDIBusinessKey","SIBWSUDDIPublication");
  if len(atts) != 0:
    print "Modifying SIBWSUDDIPublication with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSUDDIPublication configuration up to date.";

  Util.popPathElement('SIBWSUDDIPublication');
